/*
 * Decompiled with CFR 0.152.
 */
package ec.gob.sri.dimm.ats.ui.dialogos;

import ec.gob.sri.dimm.api.colecciones.ElementoNombreValor;
import ec.gob.sri.dimm.api.modelo.validacion.InformacionValidable;
import ec.gob.sri.dimm.api.modelo.validacion.ListenerValidacionModeloDialogo;
import ec.gob.sri.dimm.api.modelo.validacion.ResultadoValidacion;
import ec.gob.sri.dimm.api.ui.VistaModelo;
import ec.gob.sri.dimm.api.ui.VistaValoresPropios;
import ec.gob.sri.dimm.api.ui.dialogos.DialogoBase;
import ec.gob.sri.dimm.api.ui.util.controles.AyudanteViewer;
import ec.gob.sri.dimm.api.ui.util.eventos.AyudanteSelectionChangedEvent;
import ec.gob.sri.dimm.ats.modelo.obj.Iva;
import ec.gob.sri.dimm.ats.modelo.obj.asistente.fideicomiso.valores.ModeloValoresFideicomisos;
import ec.gob.sri.dimm.ats.modelo.obj.fideicomiso.Fideicomiso;
import java.beans.PropertyChangeListener;
import java.util.List;
import org.eclipse.core.databinding.DataBindingContext;
import org.eclipse.core.databinding.beans.BeanProperties;
import org.eclipse.core.databinding.beans.PojoObservables;
import org.eclipse.core.databinding.beans.PojoProperties;
import org.eclipse.core.databinding.observable.list.IObservableList;
import org.eclipse.core.databinding.observable.map.IObservableMap;
import org.eclipse.core.databinding.observable.set.IObservableSet;
import org.eclipse.core.databinding.observable.value.IObservableValue;
import org.eclipse.jface.databinding.swt.ISWTObservableValue;
import org.eclipse.jface.databinding.swt.WidgetProperties;
import org.eclipse.jface.databinding.viewers.ObservableListContentProvider;
import org.eclipse.jface.databinding.viewers.ObservableMapLabelProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IWorkbenchPartSite;

public class DialogoFideicomiso
extends DialogoBase
implements VistaModelo<Fideicomiso>,
VistaValoresPropios {
    private DataBindingContext m_bindingContext;
    private Fideicomiso modeloDatos;
    private ModeloValoresFideicomisos modeloValores;
    private ListenerValidacionModeloDialogo listenerValidacionModelo;
    private Text txtRucFideicomiso;
    private Text txtMonto;
    private ComboViewer cvTipoFideicomiso;
    private List<Fideicomiso> fideicomisosExistentes;
    private boolean editando;
    private Fideicomiso fidActual = new Fideicomiso();

    public DialogoFideicomiso(IWorkbenchPartSite site, List<Fideicomiso> fideicomisosExistentes, boolean editando) {
        super(site);
        this.fideicomisosExistentes = fideicomisosExistentes;
        this.editando = editando;
    }

    public void inicializarModeloValores() {
        this.modeloValores = new ModeloValoresFideicomisos();
        this.modeloValores.inicializar();
        this.modeloValores.cargarTiposFideicomiso(((Iva)this.modeloDatos.getPropietario()).periodo);
    }

    public void setModeloDatos(Fideicomiso modeloDatos) {
        this.modeloDatos = modeloDatos;
        if (this.editando) {
            this.fidActual.setRucFideicomiso(modeloDatos.getRucFideicomiso());
            this.fidActual.setTipoFideicomiso(modeloDatos.getTipoFideicomiso());
        }
    }

    public boolean close() {
        this.modeloDatos.removePropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
        return super.close();
    }

    public void procesarModeloDatos() {
        String codigoTipoFideicomiso = this.modeloDatos.getTipoFideicomiso();
        ElementoNombreValor tipoFideicomiso = this.modeloValores.obtenerTipoFideicomiso(codigoTipoFideicomiso);
        AyudanteViewer.seleccionarElemento((Viewer)this.cvTipoFideicomiso, (Object)tipoFideicomiso);
        this.listenerValidacionModelo = new ListenerValidacionModeloDialogo((InformacionValidable)this.modeloDatos, this){

            public void ejecutarValidacionFinal(ResultadoValidacion resultado) {
                if (!DialogoFideicomiso.this.modeloDatos.equals((Object)DialogoFideicomiso.this.fidActual) && DialogoFideicomiso.this.fideicomisosExistentes.contains(DialogoFideicomiso.this.modeloDatos)) {
                    resultado.fallarValidacion("El Fideicomiso ya se encuentra registrado con el mismo RUC y mismo tipo");
                }
            }
        };
        this.modeloDatos.addPropertyChangeListener((PropertyChangeListener)this.listenerValidacionModelo);
    }

    protected Point getInitialSize() {
        return new Point(480, 320);
    }

    protected Control createDialogArea(Composite parent) {
        this.setMessage("Ingrese la informaci\u00f3n del Fondo o Fideicomiso");
        this.setTitle("Informaci\u00f3n Fondo o Fideicomiso");
        Composite area = (Composite)super.createDialogArea(parent);
        Composite container = new Composite(area, 0);
        container.setLayout((Layout)new GridLayout(2, false));
        container.setLayoutData((Object)new GridData(1808));
        Label lblRucDelFideicomiso = new Label(container, 0);
        lblRucDelFideicomiso.setText("RUC del Fideicomiso");
        this.txtRucFideicomiso = new Text(container, 2048);
        this.txtRucFideicomiso.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoFideicomiso.this.txtRucFideicomiso.selectAll();
            }
        });
        this.txtRucFideicomiso.setTextLimit(13);
        GridData gd_txtRucFideicomiso = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtRucFideicomiso.widthHint = 120;
        this.txtRucFideicomiso.setLayoutData((Object)gd_txtRucFideicomiso);
        Label lblTipoDeFideicomisofondo = new Label(container, 0);
        GridData gd_lblTipoDeFideicomisofondo = new GridData(16384, 0x1000000, false, false, 1, 1);
        gd_lblTipoDeFideicomisofondo.widthHint = 150;
        lblTipoDeFideicomisofondo.setLayoutData((Object)gd_lblTipoDeFideicomisofondo);
        lblTipoDeFideicomisofondo.setText("Tipo de Fideicomiso/Fondo");
        this.cvTipoFideicomiso = new ComboViewer(container, 8);
        this.cvTipoFideicomiso.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ElementoNombreValor tipoId = (ElementoNombreValor)AyudanteSelectionChangedEvent.obtenerValorSeleccionado((SelectionChangedEvent)event);
                if (tipoId != null) {
                    DialogoFideicomiso.this.modeloDatos.setTipoFideicomiso((String)tipoId.getValor());
                    DialogoFideicomiso.this.modeloDatos.setDescripcionTipoFideicomiso(tipoId.getNombre());
                }
            }
        });
        Combo combo = this.cvTipoFideicomiso.getCombo();
        GridData gd_combo = new GridData(4, 0x1000000, true, false, 1, 1);
        gd_combo.widthHint = 150;
        combo.setLayoutData((Object)gd_combo);
        Label lblMontoDelBeneficio = new Label(container, 0);
        lblMontoDelBeneficio.setText("Monto del Beneficio Total");
        this.txtMonto = new Text(container, 2048);
        this.txtMonto.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                DialogoFideicomiso.this.txtMonto.selectAll();
            }
        });
        this.txtMonto.setTextLimit(15);
        GridData gd_txtMonto = new GridData(16384, 0x1000000, true, false, 1, 1);
        gd_txtMonto.widthHint = 120;
        this.txtMonto.setLayoutData((Object)gd_txtMonto);
        this.m_bindingContext = this.initDataBindings();
        this.procesarModeloDatos();
        return area;
    }

    protected DataBindingContext initDataBindings() {
        DataBindingContext bindingContext = new DataBindingContext();
        ISWTObservableValue observeTextTxtRucFideicomisoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtRucFideicomiso);
        IObservableValue rucFideicomisoModeloDatosObserveValue = BeanProperties.value((String)"rucFideicomiso").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtRucFideicomisoObserveWidget, rucFideicomisoModeloDatosObserveValue, null, null);
        ISWTObservableValue observeTextTxtMontoObserveWidget = WidgetProperties.text((int)24).observe((Widget)this.txtMonto);
        IObservableValue montoBeneficioTotalModeloDatosObserveValue = BeanProperties.value((String)"montoBeneficioTotal").observe((Object)this.modeloDatos);
        bindingContext.bindValue((IObservableValue)observeTextTxtMontoObserveWidget, montoBeneficioTotalModeloDatosObserveValue, null, null);
        ObservableListContentProvider listContentProvider = new ObservableListContentProvider();
        IObservableMap observeMap = PojoObservables.observeMap((IObservableSet)listContentProvider.getKnownElements(), ElementoNombreValor.class, (String)"etiqueta");
        this.cvTipoFideicomiso.setLabelProvider((IBaseLabelProvider)new ObservableMapLabelProvider(observeMap));
        this.cvTipoFideicomiso.setContentProvider((IContentProvider)listContentProvider);
        IObservableList tiposFideicomisoModeloValoresObserveList = PojoProperties.list((String)"tiposFideicomiso").observe((Object)this.modeloValores);
        this.cvTipoFideicomiso.setInput((Object)tiposFideicomisoModeloValoresObserveList);
        return bindingContext;
    }
}

